// ChatGPT conversation extractor
function extractChatGPTConversation() {
  console.log("[v0] Extracting ChatGPT conversation")

  // Get conversation title
  const titleElement = document.querySelector("h1")
  const title = titleElement ? titleElement.textContent.trim() : "Untitled ChatGPT Conversation"

  // Extract all messages
  const messages = []
  const messageElements = document.querySelectorAll("[data-message-author-role]")

  messageElements.forEach((element) => {
    const role = element.getAttribute("data-message-author-role")
    const contentElement = element.querySelector(".markdown")
    if (contentElement) {
      messages.push({
        role: role,
        content: contentElement.textContent.trim(),
      })
    }
  })

  // Combine into conversation
  const content = messages.map((msg) => `${msg.role.toUpperCase()}: ${msg.content}`).join("\n\n")

  return {
    success: true,
    title: title,
    content: content,
    tags: ["chatgpt"],
  }
}

// Listen for messages from popup
window.chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  // Handle ping request (used to check if content script is loaded)
  if (request.action === "ping") {
    sendResponse({ success: true, platform: "chatgpt" })
    return true
  }
  
  if (request.action === "extractConversation") {
    try {
      const result = extractChatGPTConversation()
      sendResponse(result)
    } catch (error) {
      console.error("[Zdravo AI] Error extracting conversation:", error)
      sendResponse({ success: false, error: error.message })
    }
  }
  return true
})
