# ZDRAVO AI - Offline Extension Installer

## 🚀 Overview

This installer provides a **fully functional ZDRAVO extension** that works even when users are NOT logged into ZDRAVO. It stores memories locally and syncs them when authentication is available.

## ✨ Key Features

### 📱 **Offline First**
- Save memories without requiring login
- Full bookmarklet functionality
- Right-click context menu
- Local storage with unlimited capacity

### 🔄 **Smart Sync**
- Automatic sync when user logs in
- Queue management for offline saves
- Visual sync indicators
- Retry failed syncs automatically

### 🎯 **Enhanced UI**
- Floating action button with sync status
- Rich context menu with options
- Offline memory viewer
- Real-time notifications

## 📦 Installation Methods

### Method 1: One-Click Installer (Recommended)
```javascript
javascript:(function(){var s=document.createElement('script');s.src='https://www.zdravoai.com/extension/installer/offline-extension.js?v='+Date.now();document.body.appendChild(s);})();
```

### Method 2: Manual Installation
1. Copy the code from `offline-extension.js`
2. Open browser console (F12)
3. Paste and press Enter
4. Extension loads immediately

### Method 3: Browser Extension Package
```bash
# Build extension package
npm run build-extension

# Install in browser:
# Chrome: chrome://extensions/ -> Load unpacked
# Firefox: about:debugging -> Load Temporary Add-on
```

## 🎮 How It Works

### **When NOT Logged In:**
1. ✅ **Save memories locally** - Full functionality
2. ✅ **Organize and search** - All features available  
3. ✅ **Export data** - Download your memories
4. 📋 **Queue for sync** - Ready when you log in

### **When Logged In:**
1. 🔄 **Auto-sync** - Memories uploaded to ZDRAVO
2. ☁️ **Cloud backup** - Safe on ZDRAVO servers
3. 📱 **Cross-device sync** - Access anywhere
4. 🎯 **Advanced features** - AI search, sharing, etc.

## 🔧 Technical Architecture

### **Storage Layers:**
```
┌─────────────────┐
│   Browser UI    │ ← Floating button, context menu
├─────────────────┤
│  Local Storage  │ ← localStorage (unlimited)
├─────────────────┤
│   Sync Queue    │ ← Pending uploads
├─────────────────┤
│  ZDRAVO API     │ ← Cloud sync (when authenticated)
└─────────────────┘
```

### **Data Flow:**
```mermaid
graph LR
    A[User Action] --> B{Auth?}
    B -->|No| C[Local Storage]
    B -->|Yes| D[ZDRAVO API]
    C --> E[Sync Queue]
    E --> F[Auto-sync when online]
    D --> G[Cloud Storage]
```

## 🛠️ Installation Scripts

### **Universal Installer Script:**
```html
<!-- Add to any webpage -->
<script src="https://www.zdravoai.com/extension/installer/offline-extension.js"></script>

<!-- Or bookmarklet version -->
<a href="javascript:(function(){var s=document.createElement('script');s.src='https://www.zdravoai.com/extension/installer/offline-extension.js?v='+Date.now();document.body.appendChild(s);})();">
  🚀 Install ZDRAVO Extension
</a>
```

### **Platform-Specific Installers:**

#### **Chrome Extension:**
```json
{
  "manifest_version": 3,
  "name": "ZDRAVO AI - Memory Assistant",
  "version": "2.0.0",
  "description": "Save AI conversations locally, sync when logged in",
  "permissions": ["storage", "activeTab", "contextMenus"],
  "content_scripts": [{
    "matches": ["<all_urls>"],
    "js": ["offline-extension.js"]
  }]
}
```

#### **Firefox Add-on:**
```json
{
  "manifest_version": 2,
  "name": "ZDRAVO AI",
  "version": "2.0.0",
  "description": "Offline-first memory assistant",
  "permissions": ["storage", "activeTab", "contextMenus"],
  "content_scripts": [{
    "matches": ["<all_urls>"],
    "js": ["offline-extension.js"]
  }]
}
```

## 🎯 User Experience

### **First Time Installation:**
1. Click installer button
2. Extension loads immediately
3. Floating button appears (top-right)
4. Right-click menu available
5. "Works offline!" notification

### **Daily Usage:**
- **Save memories**: Click floating button or right-click text
- **View memories**: Right-click → "View Saved"
- **Check sync status**: Color-coded indicator on button
- **Manual sync**: Right-click → "Sync Now" (when logged in)

### **Sync Process:**
1. User logs into ZDRAVO
2. Extension detects authentication
3. Auto-syncs queued memories
4. Shows "Synced X memories" notifications
5. Updates sync indicator to green

## 🔒 Security & Privacy

### **Local Storage:**
- ✅ **Encrypted** - AES-256 encryption optional
- ✅ **Private** - Never leaves browser without consent
- ✅ **Portable** - Export/import functionality
- ✅ **Secure** - No third-party tracking

### **Sync Security:**
- ✅ **HTTPS Only** - Encrypted transmission
- ✅ **Token-based** - OAuth 2.0 authentication
- ✅ **Scope Limited** - Only memory permissions
- ✅ **Revocable** - Disconnect anytime

## 📊 Storage Management

### **Local Storage Limits:**
- **Chrome/Edge**: ~5-10MB per origin
- **Firefox**: ~10MB per origin  
- **Safari**: ~5MB per origin
- **Solution**: Compression + cleanup old items

### **Cleanup Strategy:**
```javascript
// Auto-cleanup old memories (older than 6 months)
function cleanupOldMemories() {
  const sixMonthsAgo = Date.now() - (6 * 30 * 24 * 60 * 60 * 1000);
  const filtered = memories.filter(m => 
    new Date(m.timestamp).getTime() > sixMonthsAgo
  );
  localStorage.setItem('zdravo_memories', JSON.stringify(filtered));
}
```

## 🚀 Deployment

### **CDN Distribution:**
```html
<!-- Production -->
<script src="https://cdn.zdravoai.com/extension/v2/offline-extension.js"></script>

<!-- Development -->
<script src="https://www.zdravoai.com/extension/installer/offline-extension.js"></script>
```

### **Version Management:**
```javascript
// Auto-update check
const CURRENT_VERSION = '2.0.0';
const LATEST_VERSION = await fetchLatestVersion();

if (CURRENT_VERSION !== LATEST_VERSION) {
  showUpdateNotification();
}
```

## 🎨 Customization

### **Branding Options:**
```javascript
const CONFIG = {
  API_URL: 'https://your-brand.com',
  BRAND_NAME: 'Your Brand',
  BRAND_COLOR: '#667eea',
  LOGO_URL: 'https://your-brand.com/favicon.ico'
};
```

### **Feature Toggles:**
```javascript
const FEATURES = {
  OFFLINE_MODE: true,
  AUTO_SYNC: true,
  CONTEXT_MENU: true,
  FLOATING_BUTTON: true,
  NOTIFICATIONS: true
};
```

## 🐛 Troubleshooting

### **Common Issues:**
1. **Extension not loading**: Check console for errors
2. **Sync not working**: Verify authentication status
3. **Storage full**: Clear old memories or upgrade
4. **Button missing**: Refresh page, check for conflicts

### **Debug Mode:**
```javascript
// Enable debug logging
window.ZdravoExtension.debug = true;

// View stored data
console.log(window.ZdravoExtension.offlineMemories);
console.log(window.ZdravoExtension.syncQueue);
```

## 📞 Support

### **Documentation:**
- 📖 [Full API Docs](https://docs.zdravoai.com/extension)
- 🎥 [Video Tutorial](https://youtube.com/watch?v=zdravo-extension)
- 💬 [Community Forum](https://community.zdravoai.com)

### **Contact:**
- 📧 support@zdravoai.com
- 💬 Discord: https://discord.gg/zdravo
- 🐦 Twitter: @zdravoai

---

## 🎉 Ready to Install?
 
**Click here to install the offline extension:**
```html
<a href="javascript:(function(){var s=document.createElement('script');s.src='https://www.zdravoai.com/extension/installer/offline-extension.js?v='+Date.now();document.body.appendChild(s);})();">
  🚀 Install ZDRAVO Extension (Works Offline!)
</a>
```

**No login required. Works immediately. Syncs when you're ready.**
